"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initForNode = void 0;
var node_addon_shared_lib_loader_1 = require("@wontok/node-addon-shared-lib-loader");
var process_scanning_native_api_1 = require("./process-scanning-native-api");
var commands_1 = require("./commands");
var config_1 = __importDefault(require("./config"));
var utils_1 = require("./utils");
//#endregion
var initForNode = function (publicOptions) {
    var initOptions = {
        currentTimestamp: new Date().getTime(),
    };
    var onStateChangeCallback = function (event) {
        var state = {
            isScanning: event.payload.isScanning,
            nativeServiceAvailable: event.payload.nativeServiceAvailable,
        };
        utils_1.debug("Got new state in public JS Land: " + JSON.stringify(state) + "\n");
        publicOptions.onStateChange(state);
    };
    onStateChangeCallback.callbackName = process_scanning_native_api_1.CallbackNames.onStateChange;
    var onBlockedContentCallback = function (event) {
        var blockedContentInfo = {
            description: event.payload.description,
            reason: event.payload.reason,
        };
        utils_1.debug("Got blocked content in public JS Land: " + JSON.stringify(blockedContentInfo) + "\n");
        publicOptions.onBlockedContent(blockedContentInfo);
    };
    onBlockedContentCallback.callbackName = process_scanning_native_api_1.CallbackNames.onBlockedContent;
    var sharedLibController = node_addon_shared_lib_loader_1.initSharedLib(config_1.default.sharedLib, initOptions, [
        onStateChangeCallback,
        onBlockedContentCallback,
    ]);
    return {
        activateNativeService: function () {
            return sharedLibController.executeCommands([commands_1.commandActivateNativeService()]);
        },
        setLicenseExpirationDate: function (when) {
            return sharedLibController.executeCommands([
                commands_1.commandSetLicenseExpirationTimestamp(when),
            ]);
        },
        startScanning: function () {
            return sharedLibController.executeCommands([commands_1.commandStartScanning()]);
        },
        stopScanning: function () {
            return sharedLibController.executeCommands([commands_1.commandStopScanning()]);
        },
        unload: sharedLibController.unload,
    };
};
exports.initForNode = initForNode;
